{TST8000W.pas -- diagnostic test for K8000  TDlgWindow Demonstration}

program Tst8000wDiagnostic;

{$R Tst8000w.res}

uses WinTypes, WinProcs, WObjects, Strings, I2C;

const

	id_Timer   = 1;
  id_Icon    = 400;  {Icon resource ID}
	id_Dialog  = 500;  {Dialog resource ID}
  
	id_OutputTest = 101;  {Dialog contol ID values}
	id_SetOutputs = 102;
	id_ClrOutputs = 103;
	id_InputTest  = 104;

  id_GroupAddr = 105;
	id_A1        = 106;
	id_A0        = 107;

	id_lpt1      = 108;
	id_lpt2      = 109;
  id_lpt3      = 110;

	id_GroupIO1  = 111;
	id_GroupIO2  = 112;
	id_GroupIO3  = 113;
	id_GroupIO4  = 114;
	id_GroupIO5  = 115;
	id_GroupIO6  = 116;
	id_GroupIO7  = 117;
	id_GroupIO8  = 118;
	id_GroupIO9  = 119;
	id_GroupIO10 = 120;
	id_GroupIO11 = 121;
	id_GroupIO12 = 122;
	id_GroupIO13 = 123;
	id_GroupIO14 = 124;
	id_GroupIO15 = 125;
	id_GroupIO16 = 126;

	id_Stat1     = 127;
	id_Stat2     = 128;
	id_Stat3     = 129;
	id_Stat4     = 130;
	id_Stat5     = 131;
	id_Stat6     = 132;
	id_Stat7     = 133;
	id_Stat8     = 134;
	id_Stat9     = 135;
	id_Stat10    = 136;
	id_Stat11    = 137;
	id_Stat12    = 138;
	id_Stat13    = 139;
	id_Stat14    = 140;
	id_Stat15    = 141;
	id_Stat16    = 142;

	id_In1       = 143;
	id_In2       = 144;
	id_In3       = 145;
	id_In4       = 146;
	id_In5       = 147;
	id_In6       = 148;
	id_In7       = 149;
	id_In8       = 150;
	id_In9       = 151;
	id_In10      = 152;
	id_In11      = 153;
	id_In12      = 154;
	id_In13      = 155;
	id_In14      = 156;
	id_In15      = 157;
	id_In16      = 158;

	id_Out1      = 159;
	id_Out2      = 160;
	id_Out3      = 161;
	id_Out4      = 162;
	id_Out5      = 163;
	id_Out6      = 164;
	id_Out7      = 165;
	id_Out8      = 166;
	id_Out9      = 167;
	id_Out10     = 168;
	id_Out11     = 169;
	id_Out12     = 170;
	id_Out13     = 171;
	id_Out14     = 172;
	id_Out15     = 173;
	id_Out16     = 174;

	id_GroupDAC1 = 175;
	id_GroupDAC2 = 176;
	id_GroupDAC3 = 177;
	id_GroupDAC4 = 178;
	id_GroupDAC5 = 179;
	id_GroupDAC6 = 180;
	id_GroupDAC7 = 181;
	id_GroupDAC8 = 182;

	id_BarDAC1   = 183;
	id_BarDAC2   = 184;
	id_BarDAC3   = 185;
	id_BarDAC4   = 186;
	id_BarDAC5   = 187;
	id_BarDAC6   = 188;
	id_BarDAC7   = 189;
	id_BarDAC8   = 190;

	id_ValDAC1   = 191;
	id_ValDAC2   = 192;
	id_ValDAC3   = 193;
	id_ValDAC4   = 194;
	id_ValDAC5   = 195;
	id_ValDAC6   = 196;
	id_ValDAC7   = 197;
	id_ValDAC8   = 198;

	id_GroupDA1  = 199;
	id_BarDA1    = 200;
	id_ValDA1    = 201;

	id_GroupAD1  = 202;
	id_GroupAD2  = 203;
	id_GroupAD3  = 204;
	id_GroupAD4  = 205;

	id_BarAD1    = 206;
	id_BarAD2    = 207;
	id_BarAD3    = 208;
	id_BarAD4    = 209;

	id_ValAD1    = 210;
	id_ValAD2    = 211;
  id_ValAD3    = 212;
  id_ValAD4    = 213;

type

	Tst8000wApplication = object(TApplication)
		Firstinstance : Boolean;
    constructor Init(Aname: PChar);
		procedure InitMainWindow; virtual;
    procedure InitApplication; virtual;
	end;

	PTst8000wWindow = ^Tst8000wWindow;
	Tst8000wWindow = object(TDlgWindow)
    RadioBLpt1, RadioBLpt2, RadioBLpt3: PRadioButton;
		GroupAddr: PStatic;
		CheckboxA1,CheckboxA0: PCheckBox;

		GroupIO: array[0..15] of PStatic;
		Checkbox: array[0..15] of PCheckBox;
		RadioBIn: array[0..15] of PRadioButton;
		RadioBOut: array[0..15] of PRadioButton;

		GroupDAC: array[0..7] of PStatic;
		ScrlBrDAC: array[0..7] of PScrollBar;
		StValDAC: array[0..7] of PStatic;

		GroupDA1: PStatic;
		ScrlBrDA1: PScrollBar;
		StValDA1: PStatic;

		GroupAD: array[0..3] of PStatic;
		ScrlBrAD: array[0..3] of PScrollBar;
		StValAD: array[0..3] of PStatic;
    OldAD: array[0..3] of integer;

		Cardnr: Integer;
		Runlight: Boolean;
    RunData: word;

		constructor Init(AParent: PWindowsObject; AName: PChar);
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetupWindow; virtual;

		procedure CalculateSpeed;
		procedure ClrIO;
		procedure ClrDA;
    procedure SetIO;
		procedure SetDA;
		procedure TestDA;
		procedure UpdateInputs;

  	procedure WMCommand(var Msg: TMessage); virtual wm_First + wm_Command;
		procedure WMDestroy(var Msg: TMessage); virtual wm_first + wm_Destroy;
    procedure WMTimer(var Msg: TMessage); virtual wm_First + wm_Timer;

		procedure IDLpt1(var Msg: TMessage); virtual id_First + id_Lpt1;
		procedure IDLpt2(var Msg: TMessage); virtual id_First + id_Lpt2;
		procedure IDLpt3(var Msg: TMessage); virtual id_First + id_Lpt3;

		procedure IDOutputTest(var Msg: TMessage); virtual id_First + id_OutputTest;
		procedure IDSetOutputs(var Msg: TMessage); virtual id_First + id_SetOutputs;
		procedure IDClearOutputs(var Msg: TMessage); virtual id_First + id_ClrOutputs;
		procedure IDInputTest(var Msg: TMessage); virtual id_First + id_InputTest;

		procedure IDA1(var Msg: TMessage); virtual id_First + id_A1;
		procedure IDA0(var Msg: TMessage); virtual id_First + id_A0;
		procedure UpdateLabels;

		procedure Stat(Channelnr: integer);
    procedure ConfigIn(Channelnr: integer);
		procedure ConfigOut(Channelnr: integer);

		procedure IDBarDAC1(var Msg: TMessage); virtual id_First + id_BarDAC1;
		procedure IDBarDAC2(var Msg: TMessage); virtual id_First + id_BarDAC2;
		procedure IDBarDAC3(var Msg: TMessage); virtual id_First + id_BarDAC3;
		procedure IDBarDAC4(var Msg: TMessage); virtual id_First + id_BarDAC4;
		procedure IDBarDAC5(var Msg: TMessage); virtual id_First + id_BarDAC5;
		procedure IDBarDAC6(var Msg: TMessage); virtual id_First + id_BarDAC6;
		procedure IDBarDAC7(var Msg: TMessage); virtual id_First + id_BarDAC7;
		procedure IDBarDAC8(var Msg: TMessage); virtual id_First + id_BarDAC8;

		procedure IDBarDA1(var Msg: TMessage); virtual id_First + id_BarDA1;

		procedure IDBarAD1(var Msg: TMessage); virtual id_First + id_BarAD1;
		procedure IDBarAD2(var Msg: TMessage); virtual id_First + id_BarAD2;
		procedure IDBarAD3(var Msg: TMessage); virtual id_First + id_BarAD3;
		procedure IDBarAD4(var Msg: TMessage); virtual id_First + id_BarAD4;
	end;


{Tst8000wApplication}

{- Initialize firstInstance data field}
constructor Tst8000wApplication.Init(AName: PChar);
begin
	FirstInstance := false;
	TApplication.Init(AName)
end;

{- Called to initialize first instance only}
procedure Tst8000wApplication.InitApplication;
begin
  FirstInstance := true
end;

{Initialize Tst8000w Application object's window & check for multiple instances}
procedure Tst8000wApplication.InitMainWindow;
begin
	if FirstInstance then	MainWindow := New(PTst8000wWindow, Init(nil, PChar(id_Dialog)))
	else
  	begin
			MessageBox(0,'Program already running','Application Error',mb_TaskModal or mb_IconExclamation);
			Halt(0)
		end
end;


{Tst8000wDlgWindow}

{Initialize Tst8000wWindow object}
constructor Tst8000wWindow.Init(AParent: PWindowsObject; AName: PChar);
var AControl: PControl;
		i: integer;
begin
	TDlgWindow.Init(AParent, AName);

	{Initialize buttons}
	AControl := New(PButton,  InitResource(@Self, id_OutputTest));
	AControl := New(PButton,  InitResource(@Self, id_InputTest));
	AControl := New(PButton,  InitResource(@Self, id_SetOutputs));
	AControl := New(PButton,  InitResource(@Self, id_ClrOutputs));

	{Initialize radiobuttons for printerport selection}
	RadioBLpt1 := New(PRadioButton,  InitResource(@Self, id_Lpt1));
	RadioBLpt2 := New(PRadioButton,  InitResource(@Self, id_Lpt2));
	RadioBLpt3 := New(PRadioButton,  InitResource(@Self, id_Lpt3));

	{Initialize card address checkboxes & label for cardnumber selection}
	GroupAddr  := New(PStatic,InitResource(@Self, id_GroupAddr,7));
	CheckboxA1 := New(PCheckBox,InitResource(@Self, id_A1));
	CheckboxA0 := New(PCheckBox,InitResource(@Self, id_A0));

	{Initialize labels, checkboxes & radiobuttons for controlling digital IO's}
	for i := 0 to 15 do
		begin
			GroupIO[i]   := New(PStatic,InitResource(@Self, id_GroupIO1+i,5));
			Checkbox[i]  := New(PCheckBox,InitResource(@Self, id_Stat1+i));
			RadioBIn[i]  := New(PRadioButton,InitResource(@Self, id_In1+i));
			RadioBOut[i] := New(PRadioButton,InitResource(@Self, id_Out1+i));
    end;

	{Initialize labels, scrollbars & valuefields for DAC-channels}
	for i:= 0 to 7 do
		begin
			GroupDAC[i]  := New(PStatic,InitResource(@Self, id_GroupDAC1+i,6));
			ScrlBrDAC[i] := New(PScrollBar,InitResource(@Self, id_BarDAC1+i));
			StValDAC[i]  := New(PStatic,InitResource(@Self, id_ValDAC1+i,3));
    end;

	{Initialize label, scrollbar & valuefield for the DA-channel}
	GroupDA1  := New(PStatic,InitResource(@Self, id_GroupDA1,4));
	ScrlBrDA1 := New(PScrollBar,InitResource(@Self, id_BarDA1));
	StValDA1  := New(PStatic,InitResource(@Self, id_ValDA1,4));

	{Initialize labels, scrollbars & valuefields for AD-channels}
	for i := 0 to 3 do
		begin
			GroupAD[i]  := New(PStatic,InitResource(@Self, id_GroupAD1+i,5));
			ScrlBrAD[i] := New(PScrollBar,InitResource(@Self, id_BarAD1+i));
			StValAD[i]  := New(PStatic,InitResource(@Self, id_ValAD1+i,4))
		end;

	{Select lpt1 as communication port}
	StatusPort := MemW[$0040:$0008]+1;
	ControlPort := StatusPort+1;
	I2CbusDelay := 1;

  {Calculate communication speedfactor}
	CalculateSpeed;
end;

{- Modify window class to use custom icon}
procedure Tst8000wWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TDlgWindow.GetWindowClass(AWndClass);
	AWndClass.HIcon := LoadIcon(HInstance,PChar(id_Icon));
end;


{Prepare initial control values}
procedure Tst8000wWindow.SetupWindow;
var i: integer;
begin
	TDlgWindow.SetupWindow;

	{select lpt1 radiobutton}
	RadioBLpt1^.Check;

	{set card address & unselect address checkboxes}
	CheckBoxA1^.UnCheck; CheckBoxA0^.UnCheck;	Cardnr := 0;

	{set scrollbar range of DAC-channels}
	for i := 0 to 7 do
  	begin
			ScrlBrDAC[i]^.SetRange(0,63)
    end;

	{set scrollbar range & pagemagnitude of DA-channel}
	ScrlBrDA1^.SetRange(0,255); ScrlBrDA1^.PageMagnitude := 20;

	{set scrollbar range & reset page- and linemagnitude of AD-channels}
	for i := 0 to 3 do
  	begin
			ScrlBrAD[i]^.SetRange(0,255);	ScrlBrAD[i]^.LineMagnitude := 0; ScrlBrAD[i]^.PageMagnitude := 0;
    	OldAD[i] := 256
    end;

	{clear all outputs & read AD-inputs}
	ClrIO; TestDA;

	{initialize timer & runninglight}
  RunLight := true; RunData := 1;
	SetTimer(HWindow, id_Timer, 200,nil)
end;

{Respond to timer events}
procedure Tst8000wWindow.WMTimer(var Msg: TMessage);
begin
	if RunLight then
    begin
			if RunData = 32768 then RunData := 1 else Rundata := Rundata*2;
			UpdateIOdataArray(Cardnr*2,lo(RunData));
			UpdateIOdataArray(Cardnr*2+1,hi(RunData));
    end;
	UpdateCard(Cardnr);
	ReadCard(Cardnr);
	UpdateInputs
end;

{Intercept wm_Destroy message}
procedure Tst8000wWindow.WMDestroy(var Msg: TMessage);
begin
	KillTimer(HWindow,id_Timer);
	TDlgWindow.WMDestroy(Msg)
end;


{- Calculate communication speed depending on computer speed}
procedure Tst8000wWindow.CalculateSpeed;
VAR SerData, InputData, i, j, k : Integer;
		StartTime, StopTime, Pausefactor: LongInt;
BEGIN
	REPEAT
		StartTime := GetCurrentTime;
  {Generate start condition}
		Port[ControlPort] := $06;	{SDA Low & SCL High}
		FOR i := 0 TO I2CbusDelay DO BEGIN END;	{I2C-bus timing}
		Port[ControlPort] := $0E;	{SCL Low --> Start Condition}
		FOR i := 0 TO I2CbusDelay DO BEGIN END;	{I2C-bus timing}

	{Serial output of K8001Code for readmode}
		SerData := $01 SHL 8;	{Shift data 8 bits left}
		FOR j :=  1 TO 8 DO	{Output 8 bits}
			BEGIN
				IF SerData < 0 THEN Port[ControlPort] := $0C	{Output SDA bit High}
				ELSE Port[ControlPort] := $0E;	{SDA Low}
				FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
				Port[ControlPort] := Port[ControlPort] AND $07;	{SCL High generate clock pulse}
				SerData := SerData SHL 1;	{Shift Chipcode one bit left}
				FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
				Port[ControlPort] := Port[ControlPort] OR $08;	{SCL Low}
				FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
			END;
	{Clock pulse for acknowledgement}
		Port[ControlPort] := $0C;	{SDA High & SCL Low}
		FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
		Port[ControlPort] := $04;	{SCL High generate clock pulse}
		FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
		Port[ControlPort] := $0C;	{SCL Low}
		FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}

	{Read K8001 RAM}
		FOR k := 0 TO 256 DO			
			BEGIN
		{Clock pulse for acknowledgement from master}
				Port[ControlPort] := $0E;	{SDA & SCL Low}
				FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
				Port[ControlPort] := $06;	{SCL High generate clock pulse}
				FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
			  Port[ControlPort] := $0E;	{SCL Low}
				FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
				Port[ControlPort] := $0C;	{SDA High}
				FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
		{Serial input of one byte}
				SerData := 0;	{Clear Data}
				FOR j :=  1 TO 8 DO	{Read 8 bits}
					BEGIN
						SerData := SerData SHL 1;	{Shift data one bit left}
						Port[ControlPort] := $04;	{SCL & SDA High}
						FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
						InputData := Port[StatusPort] AND $10;	{Read Input bit}
						IF InputData <> 0 THEN SerData := SerData OR $01;	{Input SDA bit = high}
						Port[ControlPort] := $0C;	{SCL Low & SDA High}
						FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
					END;
			END;
	{Clock pulse for acknowledgement}
		Port[ControlPort] := $0C;	{SDA High & SCL Low}
		FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
		Port[ControlPort] := $04;	{SCL High generate clock pulse}
		FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
		Port[ControlPort] := $0C;	{SCL Low}
		FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
	{Generate stop condition}
		Port[ControlPort] := $0E;	{SDA & SCL Low}
		FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
		Port[ControlPort] := $06;	{SCL High}
		FOR i := 0 TO I2Cbusdelay DO BEGIN END;	{I2C-bus timing}
		Port[ControlPort] := $04;	{SDA High}

		StopTime := GetCurrentTime;
		Pausefactor := StopTime - StartTime;
	  IF Pausefactor < 0 THEN PauseFactor := Pausefactor + 8640000;
  	I2CbusDelay := I2CbusDelay * 2;
  UNTIL Pausefactor > 300;
  I2CbusDelay := I2CbusDelay DIV 2;
END; {CalculateSpeed}

{Update screenlayout with current status}
procedure Tst8000wWindow.UpdateInputs;
var StartCh,i: integer;
		S: array[0..3] of Char;
begin
  {Update checkboxes with current IO-status}
  StartCh := Cardnr*16+1;
	for i := 0 to 15 do
		if IO[StartCh+i] then CheckBox[i]^.Check else CheckBox[i]^.Uncheck;

  {Update AD-scrolbars & values if changed}
	StartCh := Cardnr*4 + 1;
  for i := 0 to 3 do
  	begin
			if OldAD[i] <> AD[StartCh+i] then
				begin
    			OldAD[i] := AD[StartCh+i];
					ScrlBrAD[i]^.SetPosition(255-AD[StartCh+i]);
					Str(AD[StartCh+i]:3,S); StValAD[i]^.SetText(S);
				end;
    end
end;

{Set all DAC & DA-channels at test values}
procedure Tst8000wWindow.TestDA;
var StartCh,value,i: integer;
		S: array[0..2] of char;
begin
	StartCh := Cardnr * 8 +1;
  value := -1;

  {set DAC-channels at testvalues & update scrollbars and valuefields}
	for i := 0 to 7 do
  	begin
      value := value + 8;
			DAC[StartCh+i] := value;
			Str(value:2,S);
			StValDAC[i]^.SetText(S);
			ScrlBrDAC[i]^.SetPosition(63-value)
    end;
	UpdateDACchip(Cardnr);

  {set DA-channel at 50% & update scrollbar and valuefield}
	OutputDAchannel(Cardnr+1,127);
	StValDA1^.SetText('127');
	ScrlBrDA1^.SetPosition(128);
end;

{Clear all IO-channels}
procedure Tst8000wWindow.ClrIO;
var Chipnr,i: integer;
begin
  Chipnr := Cardnr * 2;
  {Configure all IO-channels as outputs}
	ConfigIOchipAsOutput(Chipnr);	ConfigIOchipAsOutput(Chipnr + 1);

	{Clear all IO-channels and update screenlayout}
	ClearIOchip(Chipnr); ClearIOchip(Chipnr + 1);
	for i := 0 to 15 do
    begin
			CheckBox[i]^.UnCheck;
			RadioBIn[i]^.UnCheck;
			RadioBOut[i]^.Check
    end
end;

{Clear all DAC & DA-channels}
procedure Tst8000wWindow.ClrDA;
var i: integer;
begin
	{Clear DAC-channels & reset scrollbars and valuefields}
	ClearDACchip(Cardnr);
	for i := 0 to 7 do
  	begin
			StValDAC[i]^.SetText(' 0'); ScrlBrDAC[i]^.SetPosition(63)
    end;

  {Clear DA-channel & reset scrollbar and valuefield}
	ClearDAchannel(Cardnr + 1);
	StValDA1^.SetText(' 0');	ScrlBrDA1^.SetPosition(255);
end;

{Set all IO-channels}
procedure Tst8000wWindow.SetIO;
var Chipnr,i: integer;
begin
	Chipnr := Cardnr * 2;

	{Configure all IO-channels as outputs}
	ConfigIOchipAsOutput(Chipnr);	ConfigIOchipAsOutput(Chipnr + 1);

	{Set all IO-channels and update screenlayout}
	SetIOchip(Chipnr); SetIOchip(Chipnr + 1);
	for i := 0 to 15 do
  	begin
			CheckBox[i]^.Check;
			RadioBIn[i]^.UnCheck;
			RadioBOut[i]^.Check
    end
end;

{Set all DAC & DA-channels}
procedure Tst8000wWindow.SetDA;
var i: integer;
begin
	{Set DAC-channels & set scrollbars and valuefields at maximum}
	SetDACchip(Cardnr);
	for i := 0 to 7 do
  	begin
			StValDAC[i]^.SetText('63'); ScrlBrDAC[i]^.SetPosition(0)
    end;

	{Set DA-channel & set scrollbar and valuefield at maximum}
	SetDAchannel(Cardnr + 1);
	StValDA1^.SetText('255');	ScrlBrDA1^.SetPosition(0);
end;


procedure Tst8000wWindow.WMCommand(var Msg: TMessage);
var identifier: integer;
begin
	identifier := Msg.WParam;
	case identifier of
		id_Stat1..id_Stat16: Stat(identifier);
		id_In1..id_In16: ConfigIn(identifier);
		id_Out1..id_Out16: ConfigOut(identifier);  
	else
		TDlgWindow.WMCommand(Msg)
  end
end;

{Respond to lpt1-radiobutton message}
procedure Tst8000wWindow.IDLpt1(var Msg: TMessage);
var PortAddr: Word;
begin
	PortAddr := MemW[$0040:$0008];
  {Test if lpt1 present}
	if (PortAddr = $3BC) or (PortAddr = $278) or (PortAddr = $378) then
		begin
			RadioBLpt1^.Check;	RadioBLpt2^.UnCheck; RadioBLpt3^.UnCheck;
			StatusPort := PortAddr+1; ControlPort := PortAddr+2
    end
end;

{Respond to lpt2-radiobutton message}
procedure Tst8000wWindow.IDLpt2(var Msg: TMessage);
var PortAddr: Word;
begin
	PortAddr := MemW[$0040:$000A];
  {Test if lpt2 present}
	if (PortAddr = $3BC) or (PortAddr = $278) or (PortAddr = $378) then
		begin
			RadioBLpt1^.UnCheck;	RadioBLpt2^.Check; RadioBLpt3^.UnCheck;
			StatusPort := PortAddr+1; ControlPort := PortAddr+2
    end
end;

{Respond to lpt3-radiobutton message}
procedure Tst8000wWindow.IDLpt3(var Msg: TMessage);
var PortAddr: Word;
begin
	PortAddr := MemW[$0040:$000C];
  {Test if lpt3 present}
	if (PortAddr = $3BC) or (PortAddr = $278) or (PortAddr = $378) then
		begin
			RadioBLpt1^.UnCheck;	RadioBLpt2^.UnCheck; RadioBLpt3^.Check;
			StatusPort := PortAddr+1; ControlPort := PortAddr+2
    end
end;

{Respond to A1-checkbox}
procedure Tst8000wWindow.IDA1(var Msg: TMessage);
begin
	CheckBoxA1^.Toggle; {toggle A1-checkbox}
	UpdateLabels        {renumber all labels for IO, DAC, DA & AD-channels}
end;

{Respond to A0-checkbox}
procedure Tst8000wWindow.IDA0(var Msg: TMessage);
begin
	CheckBoxA0^.Toggle; {toggle A0-checkbox}
	UpdateLabels        {renumber labels for all IO, DAC, DA & AD-channels}
end;

{Renumber labels for all IO, DAC, DA & AD-channels}
procedure Tst8000wWindow.UpdateLabels;
var OldCardnr,i: integer;
		S: string[5];
		A: array[0..5] of Char;
begin
  {calculate cardnumber}
	OldCardnr := Cardnr; Cardnr := CheckBoxA1^.GetCheck * 2 + CheckBoxA0^.GetCheck;

  {copy configuration of IO's to new channels}
	IOconfig[Cardnr*2] := IOconfig[OldCardnr*2];
	IOconfig[Cardnr*2+1] := IOconfig[OldCardnr*2+1];

  {rename labels for all IO-channels}
	for i := 1 to 16 do
		begin
			Str(Cardnr*16+i:2,S); S := 'IO'+S; StrPCopy(A,S);
			GroupIO[i-1]^.SetText(A)
    end;

	{rename labels for all DAC-channels and copy old DAC-values to new DAC-values}
	for i := 1 to 8 do
		begin
			DAC[Cardnr*8+i] := DAC[OldCardnr*8+i];
			Str(Cardnr*8+i:2,S); S := 'DAC'+S; StrPCopy(A,S);
			GroupDAC[i-1]^.SetText(A)
    end;

	{rename label for DA-channels and copy old DA-value to new DA-value}
	DA[Cardnr+1] := DA[OldCardnr+1];
	Str(Cardnr+1:1,S); S := 'DA'+S; StrPCopy(A,S);
	GroupDA1^.SetText(A);

	{rename labels for all AD-channels}
	for i := 0 to 3 do
		begin
			Str(Cardnr*4+1+i:2,S); S := 'AD'+S; StrPCopy(A,S);
			GroupAD[i]^.SetText(A)
		end;

	UpdateCard(Cardnr);  {send values to new card}
	ReadCard(Cardnr);    {read inputs from new card}
  UpdateInputs         {update screenlayout}
end;

{Respond to output-test button}
procedure Tst8000wWindow.IDOutputTest(var Msg: TMessage);
begin
  ClrIO;                {set all IO's as output & clear them}
	TestDA;               {set all DAC & DA at testvalues}
  RunLight := true;     {enable runninglight}
end;

{Respond to clear-outputs button}
procedure Tst8000wWindow.IDClearOutputs(var Msg: TMessage);
begin
	RunLight := false;  {disable runninglight}
	ClrIO;              {clear all IO's}
	ClrDA;              {clear all DAC's & DA}
end;

{Respond to set-outputs button}
procedure Tst8000wWindow.IDSetOutputs(var Msg: TMessage);
begin
	RunLight := false;  {disable runninglight}
	SetIO;              {set all IO's}
	SetDA;              {set all DAC & DA at maximum}
end;

{Respond to input-test button}
procedure Tst8000wWindow.IDInputTest(var Msg: TMessage);
var i: integer;
begin
	{disable runninglight}
	RunLight := false;

  {Set all IO's as inputs}
	for i := 0 to 15 do
  	begin
			RadioBIn[i]^.Check;
			RadioBOut[i]^.UnCheck
		end;
	ConfigIOchipAsInput(Cardnr*2); ConfigIOchipAsInput(Cardnr*2+1); ReadCard(Cardnr);

  {Read all inputs}
	UpdateInputs
end;

{Respond to IO-status checkbox}
procedure Tst8000wWindow.Stat(Channelnr: integer);
begin
  {Calculate channelnumber}
	Channelnr := Channelnr - id_Stat1;

  {if IO configured as output then toggle status of IO-channel & Chackbox}
	if RadioBOut[Channelnr]^.GetCheck = bf_Checked then
  	begin
			CheckBox[Channelnr]^.Toggle;
      if CheckBox[Channelnr]^.GetCheck = bf_Checked then
				SetIOchannel(Cardnr*16+1+Channelnr) else ClearIOchannel(Cardnr*16+1+Channelnr)
		end
end;

{Respond to Input-Radiobutton}
procedure Tst8000wWindow.ConfigIn(Channelnr: Integer);
begin
	{Calculate channelnumber}
	Channelnr := Channelnr - id_In1;

	{Set radiobutton Input; clear radiobutton Output}
	RadioBIn[Channelnr]^.Check; RadioBOut[Channelnr]^.UnCheck;

	{Configure IO as input, read inputstatus and update screenlayout}
	ConfigIOchannelAsInput(Cardnr*16+1);
  ReadIOchannel(Cardnr*16+1);
	if IO[Cardnr*16+1] then CheckBox[Channelnr]^.Check else CheckBox[Channelnr]^.Uncheck;
end;

{Respond to Output-Radiobutton}
procedure Tst8000wWindow.ConfigOut(Channelnr: integer);
begin
	{Calculate channelnumber}
	Channelnr := Channelnr - id_Out1;

	{Set radiobutton Output; clear radiobutton Input}
	RadioBIn[Channelnr]^.UnCheck; RadioBOut[Channelnr]^.Check;

	{Configure IO as output and update IO-channel with status of checkbox}
	ConfigIOchannelAsOutput(Cardnr*16+1);
	if CheckBox[Channelnr]^.GetCheck = bf_Checked then SetIOchannel(Cardnr*16+1) else ClearIOchannel(Cardnr*16+1)
end;

{Respond to scrollbar DAC1} 
procedure Tst8000wWindow.IDBarDAC1(var Msg: TMessage);
var S: array[0..2] of Char;
		DACvalue: Integer;
begin
	DACvalue := 63-ScrlBrDAC[0]^.GetPosition;
	OutputDACchannel(Cardnr*8+1,DACvalue);
	Str(DACvalue:2,S); StValDAC[0]^.SetText(S);
end;

{Respond to scrollbar DAC2}
procedure Tst8000wWindow.IDBarDAC2(var Msg: TMessage);
var S: array[0..2] of Char;
		DACvalue: Integer;
begin
	DACvalue := 63-ScrlBrDAC[1]^.GetPosition;
	OutputDACchannel(Cardnr*8+2,DACvalue);
	Str(DACvalue:2,S); StValDAC[1]^.SetText(S);
end;

{Respond to scrollbar DAC3}
procedure Tst8000wWindow.IDBarDAC3(var Msg: TMessage);
var S: array[0..2] of Char;
		DACvalue: Integer;
begin
	DACvalue := 63-ScrlBrDAC[2]^.GetPosition;
	OutputDACchannel(Cardnr*8+3,DACvalue);
	Str(DACvalue:2,S); StValDAC[2]^.SetText(S);
end;

{Respond to scrollbar DAC4}
procedure Tst8000wWindow.IDBarDAC4(var Msg: TMessage);
var S: array[0..2] of Char;
		DACvalue: Integer;
begin
	DACvalue := 63-ScrlBrDAC[3]^.GetPosition;
	OutputDACchannel(Cardnr*8+4,DACvalue);
	Str(DACvalue:2,S); StValDAC[3]^.SetText(S);
end;

{Respond to scrollbar DAC5}
procedure Tst8000wWindow.IDBarDAC5(var Msg: TMessage);
var S: array[0..2] of Char;
		DACvalue: Integer;
begin
	DACvalue := 63-ScrlBrDAC[4]^.GetPosition;
	OutputDACchannel(Cardnr*8+5,DACvalue);
	Str(DACvalue:2,S); StValDAC[4]^.SetText(S);
end;

{Respond to scrollbar DAC6}
procedure Tst8000wWindow.IDBarDAC6(var Msg: TMessage);
var S: array[0..2] of Char;
		DACvalue: Integer;
begin
	DACvalue := 63-ScrlBrDAC[5]^.GetPosition;
	OutputDACchannel(Cardnr*8+6,DACvalue);
	Str(DACvalue:2,S); StValDAC[5]^.SetText(S);
end;

{Respond to scrollbar DAC7}
procedure Tst8000wWindow.IDBarDAC7(var Msg: TMessage);
var S: array[0..2] of Char;
		DACvalue: Integer;
begin
	DACvalue := 63-ScrlBrDAC[6]^.GetPosition;
	OutputDACchannel(Cardnr*8+7,DACvalue);
	Str(DACvalue:2,S); StValDAC[6]^.SetText(S);
end;

{Respond to scrollbar DAC8}
procedure Tst8000wWindow.IDBarDAC8(var Msg: TMessage);
var S: array[0..2] of Char;
		DACvalue: Integer;
begin
	DACvalue := 63-ScrlBrDAC[7]^.GetPosition;
	OutputDACchannel(Cardnr*8+8,DACvalue);
	Str(DACvalue:2,S); StValDAC[7]^.SetText(S);
end;


{Respond to scrollbar DA1}
procedure Tst8000wWindow.IDBarDA1(var Msg: TMessage);
var S: array[0..3] of Char;
		DAvalue: Integer;
begin
	DAvalue := 255-ScrlBrDA1^.GetPosition;
	OutputDAchannel(Cardnr+1,DAvalue);
	Str(DAvalue:3,S); StValDA1^.SetText(S);
end;

{Respond to scrollbar AD1}
procedure Tst8000wWindow.IDBarAD1(var Msg: TMessage);
begin
	ScrlBrAD[0]^.SetPosition(255-AD[Cardnr*4+1])
end;

{Respond to scrollbar AD2}
procedure Tst8000wWindow.IDBarAD2(var Msg: TMessage);
begin
	ScrlBrAD[1]^.SetPosition(255-AD[Cardnr*4+2])
end;

{Respond to scrollbar AD3}
procedure Tst8000wWindow.IDBarAD3(var Msg: TMessage);
begin
	ScrlBrAD[2]^.SetPosition(255-AD[Cardnr*4+3])
end;

{Respond to scrollbar AD4}
procedure Tst8000wWindow.IDBarAD4(var Msg: TMessage);
begin
	ScrlBrAD[3]^.SetPosition(255-AD[Cardnr*4+4])
end;

var Tst8000wApp: Tst8000wApplication;

begin
	Tst8000wApp.Init('K8000 Diagnostic Test');
	Tst8000wApp.Run;
	Tst8000wApp.Done
end.

{ Copyright 1994 by Eddy De Cocker Revision 1.00 Date: 6/12/1994}